<?php
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );
function my_theme_enqueue_styles() {
  wp_enqueue_style( 'bootstrap.css', get_stylesheet_directory_uri() . '/css/bootstrap.min.css' );
  wp_enqueue_script( 'custom.js', get_stylesheet_directory_uri() . '/js/custom.js', array ( 'jquery' ), 1.1, true);
  wp_enqueue_style( 'fontawesomecdn', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.min.css', false );
  wp_enqueue_script( 'modernizrcdn', 'https://cdnjs.cloudflare.com/ajax/libs/modernizr/2.8.3/modernizr.min.js', array ( 'jquery' ), 1.1, true);
  wp_enqueue_script( 'bootstrap.js', get_stylesheet_directory_uri() . '/js/bootstrap.bundle.min.js', array ( 'jquery' ), 1.1, true);

  wp_enqueue_script( 'aosjs', 'https://unpkg.com/aos@2.3.1/dist/aos.js', array ( 'jquery' ), 1.1, true);
  wp_enqueue_style( 'aoscss', 'https://unpkg.com/aos@2.3.1/dist/aos.css' );

  wp_enqueue_style( 'owl-css', get_stylesheet_directory_uri() . '/css/owl.carousel.min.css' );
  wp_enqueue_script( 'owl-js', get_stylesheet_directory_uri() . '/js/owl.carousel.min.js', array ( 'jquery' ), 1.1, true);

  $parent_style = 'parent-style';

  wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
  wp_enqueue_style( 'child-style',
    get_stylesheet_directory_uri() . '/style.css',
    array( $parent_style ),
    wp_get_theme()->get('Version')
  );
}

function google_fonts() {
  wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css2?family=Merriweather:ital,wght@0,300;0,400;0,700;0,900;1,300;1,400;1,700;1,900&family=Palanquin:wght@400;500;600;700&family=Roboto:wght@700;900&display=swap', false );
}
add_action( 'wp_enqueue_scripts', 'google_fonts' );

//SIDEBARS

function register_my_menus() {
    register_nav_menus(
      array(
        'footer-menu' => __( 'Footer Menu' ),
        'mobile-menu' => __( 'Mobile Menu' )
      )
    );
  }
  add_action( 'init', 'register_my_menus' );

  
  function themename_widgets_init() {

    register_sidebar( array(
      'name'          => __( 'Footer Top', 'Brisbane_Building_Inspections' ),
      'id'            => 'footer-top',
      'description'   => 'Members Of',
      'before_widget' => '',
      'after_widget'  => '',
      'before_title'  => '',
      'after_title'   => '',
    ) );
}
add_action( 'widgets_init', 'themename_widgets_init' );

add_filter( 'post_thumbnail_html', 'remove_width_attribute', 10 );
add_filter( 'image_send_to_editor', 'remove_width_attribute', 10 );

function remove_width_attribute( $html ) {
   $html = preg_replace( '/(width|height)="\d*"\s/', "", $html );
   return $html;
}

function get_post_thumbnail_url() {
  $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );
  return $thumb ? $thumb[0] : '';
}

function custom_excerpt_length( $length ) {
  return 20;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );


function isMobileDevice() {
  return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
}

if( function_exists('acf_add_options_page') ) {
	
	acf_add_options_page();
	
}

function add_last_nav_item($items, $args) {
  $perm = home_url( '/' );
  $opening = get_field('opening_hours', 'option');
  $phone = get_field('phone', 'option');
  $phone_url = $phone['url'];
  $phone_title = $phone['title'];
  $phone_target = $phone['target'] ? $phone['target'] : '_self';

  $link = get_field('contact_page', 'option');
  $link_url = $link['url'];
  $link_title = $link['title'];
  $link_target = $link['target'] ? $link['target'] : '_self';
  
  $items .= '<div class="mobile-after d-block d-lg-none text-center mt-4">
              <div class="header-contact-items d-flex align-items-center justify-content-center mb-4">
                  <div class="contact-hours text-center d-inline-block">
                    <p class="mb-0">'.$opening.'</p>
                  </div>
                  <div class="contact-phone d-inline-block border-l">
                    <a class="mob-btn text-center" href="'.$phone_url.'" target="'.$phone_target.'">'.$phone_title .'</a>
                  </div>
              </div>

              <li class="text-center mt-2 mb-3">
                <a class="mob-btn btn btn-red" href="'.$link_url.'" target="'.$link_target.'">'.$link_title .'</a>
              </li>
            </div>';
  return $items;
}
add_filter( 'wp_nav_menu_items', 'add_last_nav_item', 10, 2 );
