<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Brisbane-Building-Inspections
 */

?>


	</div><!-- #content -->

	<div class="bg_texture">
		<div class="footer">
			<div class="container py-4">
				<div class="row">
					<div class="col-12 footer-top py-3">
						<div class="row align-items-center">
							<div class="col-12 col-lg-4 col-xl-4 footer-title text-center text-lg-left mb-5 mb-lg-0">
								<h5 class="mb-0"><?php the_field('footer_title', 'option'); ?></h5>
							</div>
							<div class="col-12 col-lg-6 col-xl-6 footer-contact d-none flex-column flex-xl-row d-lg-flex align-items-center justify-content-center p-lg-0">
								<?php 
								$link = get_field('book_now_link', 'option');
								if( $link ): 
									$link_url = $link['url'];
									$link_title = $link['title'];
									$link_target = $link['target'] ? $link['target'] : '_self';
									?>
									<div class="px-3 mb-4 mb-xl-0"><a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a></div>
								<?php endif; ?>

								<div class="contact-phone d-flex align-items-center">
									<span>OR CALL US ON</span>
									
									<?php 
									$link = get_field('phone', 'option');
									if( $link ): 
										$link_url = $link['url'];
										$link_title = $link['title'];
										$link_target = $link['target'] ? $link['target'] : '_self';
										?>
										<div class="px-3"><a class="phone-link" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a></div>
									<?php endif; ?>
								</div>
							</div>
							<div class="col-12 col-lg-2 col-xl-2 social-icons text-center text-lg-right">
								<div class="pt-5 pt-lg-0">
									<?php
									if( have_rows('social_icons', 'option') ):
										while ( have_rows('social_icons', 'option') ) : the_row(); ?>
											<a target="_blank" href="<?php the_sub_field('link'); ?>"><?php the_sub_field('icon'); ?></a>
										<?php endwhile;
									endif;
									?>
								</div>
							</div>
						</div>
					</div>

					<div class="col-12 col-lg-4 text-center d-block d-lg-none">
						<?php wp_nav_menu( array( 'theme_location' => 'footer-menu' ) ); ?>
					</div>
		
					<div class="col-12 p-0">
						<hr class="white">
					</div>
				
					<div class="col-12 footer-bottom py-lg-3">
						<div class="row align-items-center">
							<div class="col-12 col-lg-4 text-center text-lg-left">
								<p><?php the_field('copyright', 'option'); ?></p>
							</div>
							<div class="col-12 col-lg-4 text-center d-none d-lg-block">
								<?php wp_nav_menu( array( 'theme_location' => 'footer-menu' ) ); ?>
							</div>
							<div class="col-12 col-lg-4 text-center text-lg-right">
								<p><?php the_field('credit', 'option'); ?></p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
